package cz.fidentis.analyst.project;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import org.openide.util.Exceptions;

/**
 * List of faces TableModel
 * 
 * @author Matej Kovar
 */
public class ModelsTableModel extends DefaultTableModel {
    
    //private final ImageIcon notCheck = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "notCheck16x16.png"));
    //private final ImageIcon check = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "check16x16.png"));
    private final ImageIcon previewBasic = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "face32x32.png"));
    /**
     * Constructor
     * @param columnNames names of Columns
     * @param rowCount number of rows
     */
    public ModelsTableModel(Object[] columnNames, int rowCount) {
        super(columnNames, rowCount);
    }


    private Class[] types = new Class [] {
        java.lang.Boolean.class, java.lang.String.class, ImageIcon.class
    };

    private boolean[] canEdit = new boolean [] {
        true, false, false
    };

    @Override
    public Class getColumnClass(int columnIndex) {
        return types [columnIndex];}

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return canEdit [columnIndex];
    }
    public Class[] getTypes() {
        return types;}

    public void setTypes(Class[] types) {
        this.types = types;}

    public boolean[] getCanEdit() {
        return canEdit;}

    public void setCanEdit(boolean[] canEdit) {
        this.canEdit = canEdit;
    }
    
    /**
     * Adds new row to model
     * @param name String name of the face
     * @param hasKD Boolean if face has KD tree calculated
     */
    public void addRowWithName(String name, Path path) {
        if (!path.toFile().exists()) {
            addRow(new Object[]{false, name, previewBasic});
        } else {
            try {
                BufferedImage image = ImageIO.read(path.toFile());
                addRow(new Object[]{false, name, new ImageIcon(image.getScaledInstance(75, 50, Image.SCALE_FAST))});
            } catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
            
        }
    }
    
    /*
     * 
    public void sortAlphabeticaly() {
        List<String> rows = new ArrayList();
        for (int i = 0; i < getRowCount(); i++) {
            rows.add(getValueAt(i, 1).toString());
        }
        Collections.sort(rows);
    }
    */

}
