package cz.fidentis.analyst.mesh.core;

import java.util.ArrayList;
import java.util.List;

/**
 * MeshModel is a root node of the hierarchy
 *
 * @author Matej Lukes
 */
public class MeshModel {
    private List<MeshFacet> facets = new ArrayList<>();

    /**
     * returns list of MeshFacets
     * @return list of MeshFacets
     */
    public List<MeshFacet> getFacets() {
        return facets;
    }

    /**
     * adds new MeshFacet to the model
     * @param facet new MeshFacet
     */
    public void addFacet(MeshFacet facet) {
        facets.add(facet);
    }
}
