package cz.fidentis.analyst.mesh.core;

import java.util.ArrayList;
import java.util.List;

/**
 * MashFacet
 *
 * @author Matej Lukes
 */
public class MeshFacet {
    private List<MeshPoint> vertexes = new ArrayList<>();
    private CornerTable cornerTable = new CornerTable();

    /**
     * returns vertex of specified index
     * @param index index of vertex
     * @return vertex
     */
    public MeshPoint GetVertex(int index) {
        return vertexes.get(index);
    }

    /**
     * adds vertex to MeshFacet
     * @param point new vertex
     */
    public void addVertex(MeshPoint point){
        vertexes.add(point);
    }

    /**
     * returns number of vertexes in MeshFacet
     * @return number of vertexes
     */
	public int getNumberOfVertexes() {
		return vertexes.size();
	}

    /**
     * returns Corner Table representing MeshFacet
     * @return corner table
     */
	public CornerTable getCornerTable() {
		return cornerTable;
	}
}

