package cz.fidentis.analyst.mesh.material;
import javax.media.j3d.Texture;
import javax.vecmath.Vector3d;

/**
 * @author Matej Lukes
 */
public class Material {
    private String name;

    // colour info
    private Vector3d ambient, diffuse, specularColors;
    private double shininess, alpha, illumination;

    // texture info
    private String textureFileName;
    private Texture texture;

    /**
     * @param arguments encapsulated arguments of constructor
     */
    public Material(MaterialConstructorArguments arguments) {
        this.name = arguments.getName();

        this.ambient = arguments.getAmbient();
        this.diffuse = arguments.getDiffuse();
        this.specularColors = arguments.getSpecularColors();

        this.shininess = arguments.getShininess();
        this.alpha = arguments.getAlpha();
        this.illumination = arguments.getIllumination();

        this.textureFileName = arguments.getTextureFileName();
        this.texture = arguments.getTexture();

    }

    @Override
    public String toString() {
        StringBuilder material = new StringBuilder();
        material.append("shininess ").append(shininess).append(System.lineSeparator());
        material.append("alpha ").append(alpha).append(System.lineSeparator());
        material.append("illumination ").append(illumination).append(System.lineSeparator());
        if (ambient != null) {
            material.append("ambient ").append(ambient.x).append(" ")
                    .append(ambient.y).append(" ")
                    .append(ambient.z).append(System.lineSeparator());
        }
        if (diffuse != null) {
            material.append("diffuse ").append(diffuse.x).append(" ")
                    .append(diffuse.y).append(" ")
                    .append(diffuse.z).append(System.lineSeparator());
        }
        if (specularColors != null) {
            material.append("specular Colors ").append(specularColors.x)
                    .append(" ").append(specularColors.y).append(" ")
                    .append(specularColors.z).append(System.lineSeparator());
        }

        return material.toString();
    }

    /**
     * @param name compared string
     * @return true if material name is same as provided string.
     */
    public boolean hasName(String name) {
        return this.name.equals(name);
    }

    /**
     * @return name of the material.
     */
    public String getName() {
        return name;
    }

    /**
     * @return illumination
     */
    public double getIllumination() {
        return illumination;
    }

    /**
     * @return alpha
     */
    public double getAlpha() {
        return alpha;
    }

    /**
     * @return shininess
     */
    public double getShininess() {
        return shininess;
    }

    /**
     * @return ambient
     */
    public Vector3d getAmbient() {
        return ambient;
    }

    /**
     * @return diffuse
     */
    public Vector3d getDiffuse() {
        return diffuse;
    }


    /**
     * @return specular colors
     */
    public Vector3d getSpecularColors() {
        return specularColors;
    }

    /**
     * @return
     */
    public Texture getTexture() {
        return texture;
    }

    /**
     * @return
     */
    public String getTextureFile() {
        return textureFileName;
    }
}
