package cz.fidentis.analyst.feature;

import java.io.Serializable;
import java.util.Objects;
import javax.vecmath.Point3d;

/**
 *
 * @author Jakub Kolman
 */
public class FeaturePoint implements Serializable {

    private Point3d position;
    private final FeaturePointType featurePointType;

    /**
     * Constructor.
     *
     * @param x Location x
     * @param y Location y
     * @param z Location z
     * @param featurePointType Original type
     */
    public FeaturePoint(double x, double y, double z, FeaturePointType featurePointType) {
        this.position = new Point3d(x, y, z);
        this.featurePointType = featurePointType;
    }

    public Point3d getPosition() {
        return position;
    }

    public double getX() {
        return position.x;
    }

    public double getY() {
        return position.y;
    }

    public double getZ() {
        return position.z;
    }

    public FeaturePointType getFeaturePointType() {
        return featurePointType;
    }

    @Override
    public boolean equals(Object o) {
        // self check
        if (this == o) {
            return true;
        }
        // null check
        if (o == null) {
            return false;
        }
        // type check and cast
        if (getClass() != o.getClass()) {
            return false;
        }
        FeaturePoint fp = (FeaturePoint) o;
        // field comparison
        return Objects.equals(position.x, fp.position.x)
                && Objects.equals(position.y, fp.position.y)
                && Objects.equals(position.z, fp.position.z)
                && Objects.equals(featurePointType.getCode(), fp.featurePointType.getCode())
                && Objects.equals(featurePointType.getInfo(), fp.featurePointType.getInfo())
                && Objects.equals(featurePointType.getName(), fp.featurePointType.getName())
                && Objects.equals(featurePointType.getType(), fp.featurePointType.getType());
    }

    /**
     * generated hash code function
     * 
     * @return 
     */
    @Override
    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Objects.hashCode(this.position);
        hash = 23 * hash + Objects.hashCode(this.featurePointType);
        return hash;
    }
}
