/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.procrustes;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import cz.fidentis.analyst.mesh.core.MeshPoint;
import cz.fidentis.analyst.procrustes.utils.ProcrustesAnalysisUtils;

import javax.vecmath.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 *
 * @author Jakub Kolman
 */
public class ProcrustesAnalysisFaceModel {
    
    private HashMap<Integer, FeaturePoint> featurePointsMap;        // sorted by feature point type
    private List<MeshPoint> vertices;
    private MeshModel meshModel;
    private final HashMap<Integer, Integer> featurePointTypeCorrespondence;


    public ProcrustesAnalysisFaceModel(HumanFace face) {
        // getFeaturePoints() returns unmodifiable List. To sort it we need to make copy first
        List<FeaturePoint> modifiableFeaturePointList = new ArrayList<>(face.getFeaturePoints());

        // To be able to move vertices we have to make a copy of them because  getFacets() returns unmodifiable List
        List<MeshPoint> modifiableVertices = new ArrayList<>(face.getMeshModel().getFacets().get(0).getVertices());

        this.featurePointsMap = ProcrustesAnalysisUtils.generateFeaturePointHashMap(
                ProcrustesAnalysisUtils.sortListByFeaturePointType(modifiableFeaturePointList));
        this.meshModel = face.getMeshModel();
        this.vertices = modifiableVertices;
        this.featurePointTypeCorrespondence = createFeaturePointTypeCorrespondence(face.getFeaturePoints());
    }

    public MeshModel getMeshModel() {
        return meshModel;
    }

    public void setVertices(List<MeshPoint> vertices) {
        this.vertices = vertices;
    }

    public List<MeshPoint> getVertices() {
        return vertices;
    }

    public void setFeaturePointsMap(HashMap<Integer, FeaturePoint> featurePointsMap) {
        this.featurePointsMap = featurePointsMap;
    }

    public HashMap<Integer, FeaturePoint> getFeaturePointsMap() {
        return featurePointsMap;
    }

    public HashMap<Integer, Integer> getFeaturePointTypeCorrespondence() {
        return featurePointTypeCorrespondence;
    }

    /**
     * Creates corresponding key value pair of matrix row index and a feature point type value.
     * It is used in {@link cz.fidentis.analyst.procrustes.utils.ProcrustesAnalysisUtils#createFeaturePointMapFromMatrix}
     * so we can get back type of feature point after working with matrices where the type is not stored,
     * but instead are used matrix indexes.
     *
     * @param fpList
     * @return
     */
    private HashMap<Integer, Integer> createFeaturePointTypeCorrespondence(List<FeaturePoint> fpList) {
        HashMap<Integer, Integer> map = new HashMap<>();
        for (int i = 0; i < fpList.size(); i++) {
            map.put(i, fpList.get(i).getFeaturePointType().getType());
        }
        return map;
    }

//    public List<FeaturePoint> getFeaturePoints() {
//        return new List<FeaturePoint>(this.featurePointsMap.values());
//    }

}
