/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.procrustes;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.face.HumanFaceFactory;
import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.feature.services.FeaturePointCsvLoader;
import cz.fidentis.analyst.feature.services.FeaturePointExportService;
import cz.fidentis.analyst.feature.services.FeaturePointImportService;
import cz.fidentis.analyst.feature.utils.FileResourcesUtils;
import cz.fidentis.analyst.mesh.core.MeshModel;
import cz.fidentis.analyst.mesh.io.MeshObjLoader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

/**
 *
 * @author Jakub Kolman
 */
public class ProcrustesAnalysisComparison {

    private static final Path FP_FILE_DIRECTORY = Paths.get(
            "Comparison","src", "main", "resources", "cz", "fidentis", "comparison", "procrustesAnalysis", "faces");
    private static final Path FACE_1_PATH = Paths.get(
             "cz", "fidentis", "comparison", "procrustesAnalysis", "faces", "0002_01_ECA.obj");
    private static final Path FACE_2_PATH = Paths.get(
             "cz", "fidentis", "comparison", "procrustesAnalysis", "faces", "0002_02_ECA.obj");

    private static final String FP_HEAD_01 = "0002_01_landmarks.csv";
    private static final String FP_HEAD_02 = "0002_02_landmarks.csv";
    private static final String HEAD_01 = "0002_01_ECA.obj";
    private static final String HEAD_02 = "0002_01_ECA.obj";

    private static final String OLD_FP_HEAD_01 = "head01_landmarks.csv";
    private static final String OLD_FP_HEAD_02 = "head02_landmarks.csv";
    private static final Path OLD_HEAD_01_PATH = Paths.get(
            "cz", "fidentis", "comparison", "procrustesAnalysis", "faces", "head01_ECA.obj");
    private static final Path OLD_HEAD_02_PATH = Paths.get(
            "cz", "fidentis", "comparison", "procrustesAnalysis", "faces", "head02_ECA.obj");




    public static void main(String[] args) throws IOException, URISyntaxException {

        FileResourcesUtils fru = new FileResourcesUtils();
        HumanFaceFactory factory = new HumanFaceFactory();
        FeaturePointImportService featurePointImportService = new FeaturePointImportService();

//        System.out.println("Working Directory = " + System.getProperty("user.dir"));

        // HEADS from the new models
//        List<FeaturePoint> fpList01 = featurePointImportService.importFeaturePoints(
//                FP_FILE_DIRECTORY.toString(), FP_HEAD_01);
//        List<FeaturePoint> fpList02 = featurePointImportService.importFeaturePoints(
//                FP_FILE_DIRECTORY.toString(), FP_HEAD_02);
//        HumanFace face1 = factory.getFace(factory.loadFace(fru.getFileFromResource(FACE_1_PATH.toString())));
//        HumanFace face2 = factory.getFace(factory.loadFace(fru.getFileFromResource(FACE_2_PATH.toString())));

        // HEADS from the old models
        List<FeaturePoint> fpList01 = featurePointImportService.importFeaturePoints(
                FP_FILE_DIRECTORY.toString(), OLD_FP_HEAD_01);
        List<FeaturePoint> fpList02 = featurePointImportService.importFeaturePoints(
                FP_FILE_DIRECTORY.toString(), OLD_FP_HEAD_02);
        HumanFace face1 = factory.getFace(factory.loadFace(fru.getFileFromResource(OLD_HEAD_01_PATH.toString())));
        HumanFace face2 = factory.getFace(factory.loadFace(fru.getFileFromResource(OLD_HEAD_02_PATH.toString())));

        face1.setFeaturePoints(fpList01);
        face2.setFeaturePoints(fpList02);

        ProcrustesAnalysis pa = new ProcrustesAnalysis(face1, face2);


//
//        FeaturePointExportService featurePointExportService = new FeaturePointExportService();
//        featurePointExportService.exportFeaturePoints(fpList01, "head01", "CSV");
//        featurePointExportService.exportFeaturePoints(fpList01, "head02", "CSV");

        System.out.println("finished");


    }
}

